package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.StackName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CloudFormationCollectionFilter(
    stackNames: Option[Iterable[StackName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.CloudFormationCollectionFilter = {
    import CloudFormationCollectionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.CloudFormationCollectionFilter
      .builder()
      .optionallyWith(
        stackNames.map(value =>
          value.map { item =>
            StackName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stackNames)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.CloudFormationCollectionFilter.ReadOnly =
    zio.aws.devopsguru.model.CloudFormationCollectionFilter
      .wrap(buildAwsValue())
}
object CloudFormationCollectionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.CloudFormationCollectionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.CloudFormationCollectionFilter =
      zio.aws.devopsguru.model
        .CloudFormationCollectionFilter(stackNames.map(value => value))
    def stackNames: Option[List[StackName]]
    def getStackNames: ZIO[Any, AwsError, List[StackName]] =
      AwsError.unwrapOptionField("stackNames", stackNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudFormationCollectionFilter
  ) extends zio.aws.devopsguru.model.CloudFormationCollectionFilter.ReadOnly {
    override val stackNames: Option[List[StackName]] = scala
      .Option(impl.stackNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.primitives.StackName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudFormationCollectionFilter
  ): zio.aws.devopsguru.model.CloudFormationCollectionFilter.ReadOnly =
    new Wrapper(impl)
}
