package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{ResourceType, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnomalyResource(
    name: Option[ResourceName] = None,
    `type`: Option[ResourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.AnomalyResource = {
    import AnomalyResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.AnomalyResource
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        `type`.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.AnomalyResource.ReadOnly =
    zio.aws.devopsguru.model.AnomalyResource.wrap(buildAwsValue())
}
object AnomalyResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.AnomalyResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.AnomalyResource =
      zio.aws.devopsguru.model
        .AnomalyResource(name.map(value => value), `type`.map(value => value))
    def name: Option[ResourceName]
    def `type`: Option[ResourceType]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalyResource
  ) extends zio.aws.devopsguru.model.AnomalyResource.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.devopsguru.model.primitives.ResourceName(value))
    override val `type`: Option[ResourceType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.devopsguru.model.primitives.ResourceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalyResource
  ): zio.aws.devopsguru.model.AnomalyResource.ReadOnly = new Wrapper(impl)
}
