package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  RecommendationRelatedEventResourceType,
  RecommendationRelatedEventResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RecommendationRelatedEventResource(
    name: Option[RecommendationRelatedEventResourceName] = None,
    `type`: Option[RecommendationRelatedEventResourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEventResource = {
    import RecommendationRelatedEventResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEventResource
      .builder()
      .optionallyWith(
        name.map(value =>
          RecommendationRelatedEventResourceName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        `type`.map(value =>
          RecommendationRelatedEventResourceType.unwrap(value): java.lang.String
        )
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.RecommendationRelatedEventResource.ReadOnly =
    zio.aws.devopsguru.model.RecommendationRelatedEventResource
      .wrap(buildAwsValue())
}
object RecommendationRelatedEventResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEventResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.RecommendationRelatedEventResource =
      zio.aws.devopsguru.model.RecommendationRelatedEventResource(
        name.map(value => value),
        `type`.map(value => value)
      )
    def name: Option[RecommendationRelatedEventResourceName]
    def `type`: Option[RecommendationRelatedEventResourceType]
    def getName: ZIO[Any, AwsError, RecommendationRelatedEventResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, RecommendationRelatedEventResourceType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEventResource
  ) extends zio.aws.devopsguru.model.RecommendationRelatedEventResource.ReadOnly {
    override val name: Option[RecommendationRelatedEventResourceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .RecommendationRelatedEventResourceName(value)
      )
    override val `type`: Option[RecommendationRelatedEventResourceType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .RecommendationRelatedEventResourceType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEventResource
  ): zio.aws.devopsguru.model.RecommendationRelatedEventResource.ReadOnly =
    new Wrapper(impl)
}
