package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CostEstimationTimeRange(
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.CostEstimationTimeRange = {
    import CostEstimationTimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.CostEstimationTimeRange
      .builder()
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.CostEstimationTimeRange.ReadOnly =
    zio.aws.devopsguru.model.CostEstimationTimeRange.wrap(buildAwsValue())
}
object CostEstimationTimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.CostEstimationTimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.CostEstimationTimeRange =
      zio.aws.devopsguru.model.CostEstimationTimeRange(
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.CostEstimationTimeRange
  ) extends zio.aws.devopsguru.model.CostEstimationTimeRange.ReadOnly {
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.CostEstimationTimeRange
  ): zio.aws.devopsguru.model.CostEstimationTimeRange.ReadOnly = new Wrapper(
    impl
  )
}
