package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  OrganizationalUnitId,
  AwsAccountId,
  Timestamp
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeOrganizationOverviewRequest(
    fromTime: Timestamp,
    toTime: Option[Timestamp] = None,
    accountIds: Option[Iterable[AwsAccountId]] = None,
    organizationalUnitIds: Option[Iterable[OrganizationalUnitId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewRequest = {
    import DescribeOrganizationOverviewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewRequest
      .builder()
      .fromTime(Timestamp.unwrap(fromTime): Instant)
      .optionallyWith(toTime.map(value => Timestamp.unwrap(value): Instant))(
        _.toTime
      )
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AwsAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        organizationalUnitIds.map(value =>
          value.map { item =>
            OrganizationalUnitId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitIds)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.DescribeOrganizationOverviewRequest.ReadOnly =
    zio.aws.devopsguru.model.DescribeOrganizationOverviewRequest
      .wrap(buildAwsValue())
}
object DescribeOrganizationOverviewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.DescribeOrganizationOverviewRequest =
      zio.aws.devopsguru.model.DescribeOrganizationOverviewRequest(
        fromTime,
        toTime.map(value => value),
        accountIds.map(value => value),
        organizationalUnitIds.map(value => value)
      )
    def fromTime: Timestamp
    def toTime: Option[Timestamp]
    def accountIds: Option[List[AwsAccountId]]
    def organizationalUnitIds: Option[List[OrganizationalUnitId]]
    def getFromTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(fromTime)
    def getToTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("toTime", toTime)
    def getAccountIds: ZIO[Any, AwsError, List[AwsAccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getOrganizationalUnitIds
        : ZIO[Any, AwsError, List[OrganizationalUnitId]] =
      AwsError.unwrapOptionField("organizationalUnitIds", organizationalUnitIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewRequest
  ) extends zio.aws.devopsguru.model.DescribeOrganizationOverviewRequest.ReadOnly {
    override val fromTime: Timestamp =
      zio.aws.devopsguru.model.primitives.Timestamp(impl.fromTime())
    override val toTime: Option[Timestamp] = scala
      .Option(impl.toTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
    override val accountIds: Option[List[AwsAccountId]] = scala
      .Option(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.primitives.AwsAccountId(item)
        }.toList
      )
    override val organizationalUnitIds: Option[List[OrganizationalUnitId]] =
      scala
        .Option(impl.organizationalUnitIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.primitives.OrganizationalUnitId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewRequest
  ): zio.aws.devopsguru.model.DescribeOrganizationOverviewRequest.ReadOnly =
    new Wrapper(impl)
}
