package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OpsCenterIntegrationConfig(
    optInStatus: Option[zio.aws.devopsguru.model.OptInStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.OpsCenterIntegrationConfig = {
    import OpsCenterIntegrationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.OpsCenterIntegrationConfig
      .builder()
      .optionallyWith(optInStatus.map(value => value.unwrap))(_.optInStatus)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.OpsCenterIntegrationConfig.ReadOnly =
    zio.aws.devopsguru.model.OpsCenterIntegrationConfig.wrap(buildAwsValue())
}
object OpsCenterIntegrationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.OpsCenterIntegrationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.OpsCenterIntegrationConfig =
      zio.aws.devopsguru.model
        .OpsCenterIntegrationConfig(optInStatus.map(value => value))
    def optInStatus: Option[zio.aws.devopsguru.model.OptInStatus]
    def getOptInStatus
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.OptInStatus] =
      AwsError.unwrapOptionField("optInStatus", optInStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.OpsCenterIntegrationConfig
  ) extends zio.aws.devopsguru.model.OpsCenterIntegrationConfig.ReadOnly {
    override val optInStatus: Option[zio.aws.devopsguru.model.OptInStatus] =
      scala
        .Option(impl.optInStatus())
        .map(value => zio.aws.devopsguru.model.OptInStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.OpsCenterIntegrationConfig
  ): zio.aws.devopsguru.model.OpsCenterIntegrationConfig.ReadOnly = new Wrapper(
    impl
  )
}
