package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait UserDesignation {
  def unwrap: software.amazon.awssdk.services.datazone.model.UserDesignation
}
object UserDesignation {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.UserDesignation
  ): zio.aws.datazone.model.UserDesignation = value match {
    case software.amazon.awssdk.services.datazone.model.UserDesignation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.UserDesignation.PROJECT_OWNER =>
      val r = PROJECT_OWNER
      r
    case software.amazon.awssdk.services.datazone.model.UserDesignation.PROJECT_CONTRIBUTOR =>
      val r = PROJECT_CONTRIBUTOR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.UserDesignation {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserDesignation =
      software.amazon.awssdk.services.datazone.model.UserDesignation.UNKNOWN_TO_SDK_VERSION
  }
  case object PROJECT_OWNER extends zio.aws.datazone.model.UserDesignation {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserDesignation =
      software.amazon.awssdk.services.datazone.model.UserDesignation.PROJECT_OWNER
  }
  case object PROJECT_CONTRIBUTOR
      extends zio.aws.datazone.model.UserDesignation {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserDesignation =
      software.amazon.awssdk.services.datazone.model.UserDesignation.PROJECT_CONTRIBUTOR
  }
}
