package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{DomainId, RoleArn}
import scala.jdk.CollectionConverters.*
final case class UpdateDomainRequest(
    clientToken: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    domainExecutionRole: Optional[RoleArn] = Optional.Absent,
    identifier: DomainId,
    name: Optional[String] = Optional.Absent,
    singleSignOn: Optional[zio.aws.datazone.model.SingleSignOn] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateDomainRequest = {
    import UpdateDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateDomainRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        domainExecutionRole.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.domainExecutionRole)
      .identifier(DomainId.unwrap(identifier): java.lang.String)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(singleSignOn.map(value => value.buildAwsValue()))(
        _.singleSignOn
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UpdateDomainRequest.ReadOnly =
    zio.aws.datazone.model.UpdateDomainRequest.wrap(buildAwsValue())
}
object UpdateDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateDomainRequest =
      zio.aws.datazone.model.UpdateDomainRequest(
        clientToken.map(value => value),
        description.map(value => value),
        domainExecutionRole.map(value => value),
        identifier,
        name.map(value => value),
        singleSignOn.map(value => value.asEditable)
      )
    def clientToken: Optional[String]
    def description: Optional[String]
    def domainExecutionRole: Optional[RoleArn]
    def identifier: DomainId
    def name: Optional[String]
    def singleSignOn: Optional[zio.aws.datazone.model.SingleSignOn.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDomainExecutionRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("domainExecutionRole", domainExecutionRole)
    def getIdentifier: ZIO[Any, Nothing, DomainId] = ZIO.succeed(identifier)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getSingleSignOn
        : ZIO[Any, AwsError, zio.aws.datazone.model.SingleSignOn.ReadOnly] =
      AwsError.unwrapOptionField("singleSignOn", singleSignOn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateDomainRequest
  ) extends zio.aws.datazone.model.UpdateDomainRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val domainExecutionRole: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.domainExecutionRole())
      .map(value => zio.aws.datazone.model.primitives.RoleArn(value))
    override val identifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.identifier())
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val singleSignOn
        : Optional[zio.aws.datazone.model.SingleSignOn.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singleSignOn())
        .map(value => zio.aws.datazone.model.SingleSignOn.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateDomainRequest
  ): zio.aws.datazone.model.UpdateDomainRequest.ReadOnly = new Wrapper(impl)
}
