package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.GlossaryTermId
import scala.jdk.CollectionConverters.*
final case class TermRelations(
    classifies: Optional[Iterable[GlossaryTermId]] = Optional.Absent,
    isA: Optional[Iterable[GlossaryTermId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.TermRelations = {
    import TermRelations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.TermRelations
      .builder()
      .optionallyWith(
        classifies.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.classifies)
      .optionallyWith(
        isA.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.isA)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.TermRelations.ReadOnly =
    zio.aws.datazone.model.TermRelations.wrap(buildAwsValue())
}
object TermRelations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.TermRelations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.TermRelations =
      zio.aws.datazone.model
        .TermRelations(classifies.map(value => value), isA.map(value => value))
    def classifies: Optional[List[GlossaryTermId]]
    def isA: Optional[List[GlossaryTermId]]
    def getClassifies: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("classifies", classifies)
    def getIsA: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("isA", isA)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.TermRelations
  ) extends zio.aws.datazone.model.TermRelations.ReadOnly {
    override val classifies: Optional[List[GlossaryTermId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classifies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.GlossaryTermId(item)
          }.toList
        )
    override val isA: Optional[List[GlossaryTermId]] = zio.aws.core.internal
      .optionalFromNullable(impl.isA())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datazone.model.primitives.GlossaryTermId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.TermRelations
  ): zio.aws.datazone.model.TermRelations.ReadOnly = new Wrapper(impl)
}
