package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SubscribedPrincipalInput(
    project: Optional[zio.aws.datazone.model.SubscribedProjectInput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SubscribedPrincipalInput = {
    import SubscribedPrincipalInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SubscribedPrincipalInput
      .builder()
      .optionallyWith(project.map(value => value.buildAwsValue()))(_.project)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SubscribedPrincipalInput.ReadOnly =
    zio.aws.datazone.model.SubscribedPrincipalInput.wrap(buildAwsValue())
}
object SubscribedPrincipalInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SubscribedPrincipalInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SubscribedPrincipalInput =
      zio.aws.datazone.model
        .SubscribedPrincipalInput(project.map(value => value.asEditable))
    def project
        : Optional[zio.aws.datazone.model.SubscribedProjectInput.ReadOnly]
    def getProject: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.SubscribedProjectInput.ReadOnly
    ] = AwsError.unwrapOptionField("project", project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedPrincipalInput
  ) extends zio.aws.datazone.model.SubscribedPrincipalInput.ReadOnly {
    override val project
        : Optional[zio.aws.datazone.model.SubscribedProjectInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.project())
        .map(value => zio.aws.datazone.model.SubscribedProjectInput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedPrincipalInput
  ): zio.aws.datazone.model.SubscribedPrincipalInput.ReadOnly = new Wrapper(
    impl
  )
}
