package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SubscribedPrincipal(
    project: Optional[zio.aws.datazone.model.SubscribedProject] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SubscribedPrincipal = {
    import SubscribedPrincipal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SubscribedPrincipal
      .builder()
      .optionallyWith(project.map(value => value.buildAwsValue()))(_.project)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SubscribedPrincipal.ReadOnly =
    zio.aws.datazone.model.SubscribedPrincipal.wrap(buildAwsValue())
}
object SubscribedPrincipal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SubscribedPrincipal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SubscribedPrincipal =
      zio.aws.datazone.model
        .SubscribedPrincipal(project.map(value => value.asEditable))
    def project: Optional[zio.aws.datazone.model.SubscribedProject.ReadOnly]
    def getProject: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.SubscribedProject.ReadOnly
    ] = AwsError.unwrapOptionField("project", project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedPrincipal
  ) extends zio.aws.datazone.model.SubscribedPrincipal.ReadOnly {
    override val project
        : Optional[zio.aws.datazone.model.SubscribedProject.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.project())
        .map(value => zio.aws.datazone.model.SubscribedProject.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedPrincipal
  ): zio.aws.datazone.model.SubscribedPrincipal.ReadOnly = new Wrapper(impl)
}
