package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{DomainId, DataSourceId}
import scala.jdk.CollectionConverters.*
final case class StartDataSourceRunRequest(
    clientToken: Optional[String] = Optional.Absent,
    dataSourceIdentifier: DataSourceId,
    domainIdentifier: DomainId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.StartDataSourceRunRequest = {
    import StartDataSourceRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.StartDataSourceRunRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .dataSourceIdentifier(
        DataSourceId.unwrap(dataSourceIdentifier): java.lang.String
      )
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.StartDataSourceRunRequest.ReadOnly =
    zio.aws.datazone.model.StartDataSourceRunRequest.wrap(buildAwsValue())
}
object StartDataSourceRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.StartDataSourceRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.StartDataSourceRunRequest =
      zio.aws.datazone.model.StartDataSourceRunRequest(
        clientToken.map(value => value),
        dataSourceIdentifier,
        domainIdentifier
      )
    def clientToken: Optional[String]
    def dataSourceIdentifier: DataSourceId
    def domainIdentifier: DomainId
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDataSourceIdentifier: ZIO[Any, Nothing, DataSourceId] =
      ZIO.succeed(dataSourceIdentifier)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.StartDataSourceRunRequest
  ) extends zio.aws.datazone.model.StartDataSourceRunRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dataSourceIdentifier: DataSourceId =
      zio.aws.datazone.model.primitives
        .DataSourceId(impl.dataSourceIdentifier())
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.StartDataSourceRunRequest
  ): zio.aws.datazone.model.StartDataSourceRunRequest.ReadOnly = new Wrapper(
    impl
  )
}
