package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  SubscriptionRequestId,
  DomainId,
  DecisionComment
}
import scala.jdk.CollectionConverters.*
final case class RejectSubscriptionRequestRequest(
    decisionComment: Optional[DecisionComment] = Optional.Absent,
    domainIdentifier: DomainId,
    identifier: SubscriptionRequestId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestRequest = {
    import RejectSubscriptionRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestRequest
      .builder()
      .optionallyWith(
        decisionComment.map(value =>
          DecisionComment.unwrap(value): java.lang.String
        )
      )(_.decisionComment)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(SubscriptionRequestId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.RejectSubscriptionRequestRequest.ReadOnly =
    zio.aws.datazone.model.RejectSubscriptionRequestRequest
      .wrap(buildAwsValue())
}
object RejectSubscriptionRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RejectSubscriptionRequestRequest =
      zio.aws.datazone.model.RejectSubscriptionRequestRequest(
        decisionComment.map(value => value),
        domainIdentifier,
        identifier
      )
    def decisionComment: Optional[DecisionComment]
    def domainIdentifier: DomainId
    def identifier: SubscriptionRequestId
    def getDecisionComment: ZIO[Any, AwsError, DecisionComment] =
      AwsError.unwrapOptionField("decisionComment", decisionComment)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, SubscriptionRequestId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestRequest
  ) extends zio.aws.datazone.model.RejectSubscriptionRequestRequest.ReadOnly {
    override val decisionComment: Optional[DecisionComment] =
      zio.aws.core.internal
        .optionalFromNullable(impl.decisionComment())
        .map(value => zio.aws.datazone.model.primitives.DecisionComment(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: SubscriptionRequestId =
      zio.aws.datazone.model.primitives.SubscriptionRequestId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestRequest
  ): zio.aws.datazone.model.RejectSubscriptionRequestRequest.ReadOnly =
    new Wrapper(impl)
}
