package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait RejectRuleBehavior {
  def unwrap: software.amazon.awssdk.services.datazone.model.RejectRuleBehavior
}
object RejectRuleBehavior {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.RejectRuleBehavior
  ): zio.aws.datazone.model.RejectRuleBehavior = value match {
    case software.amazon.awssdk.services.datazone.model.RejectRuleBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.RejectRuleBehavior.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.datazone.model.RejectRuleBehavior.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.RejectRuleBehavior {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.RejectRuleBehavior =
      software.amazon.awssdk.services.datazone.model.RejectRuleBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.datazone.model.RejectRuleBehavior {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.RejectRuleBehavior =
      software.amazon.awssdk.services.datazone.model.RejectRuleBehavior.ALL
  }
  case object NONE extends zio.aws.datazone.model.RejectRuleBehavior {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.RejectRuleBehavior =
      software.amazon.awssdk.services.datazone.model.RejectRuleBehavior.NONE
  }
}
