package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.RedshiftServerlessStorageWorkgroupNameString
import scala.jdk.CollectionConverters.*
final case class RedshiftServerlessStorage(
    workgroupName: RedshiftServerlessStorageWorkgroupNameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RedshiftServerlessStorage = {
    import RedshiftServerlessStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RedshiftServerlessStorage
      .builder()
      .workgroupName(
        RedshiftServerlessStorageWorkgroupNameString.unwrap(
          workgroupName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.RedshiftServerlessStorage.ReadOnly =
    zio.aws.datazone.model.RedshiftServerlessStorage.wrap(buildAwsValue())
}
object RedshiftServerlessStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RedshiftServerlessStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RedshiftServerlessStorage =
      zio.aws.datazone.model.RedshiftServerlessStorage(workgroupName)
    def workgroupName: RedshiftServerlessStorageWorkgroupNameString
    def getWorkgroupName
        : ZIO[Any, Nothing, RedshiftServerlessStorageWorkgroupNameString] =
      ZIO.succeed(workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RedshiftServerlessStorage
  ) extends zio.aws.datazone.model.RedshiftServerlessStorage.ReadOnly {
    override val workgroupName: RedshiftServerlessStorageWorkgroupNameString =
      zio.aws.datazone.model.primitives
        .RedshiftServerlessStorageWorkgroupNameString(impl.workgroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RedshiftServerlessStorage
  ): zio.aws.datazone.model.RedshiftServerlessStorage.ReadOnly = new Wrapper(
    impl
  )
}
