package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProvisioningProperties(
    cloudFormation: Optional[zio.aws.datazone.model.CloudFormationProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ProvisioningProperties = {
    import ProvisioningProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ProvisioningProperties
      .builder()
      .optionallyWith(cloudFormation.map(value => value.buildAwsValue()))(
        _.cloudFormation
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ProvisioningProperties.ReadOnly =
    zio.aws.datazone.model.ProvisioningProperties.wrap(buildAwsValue())
}
object ProvisioningProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ProvisioningProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ProvisioningProperties =
      zio.aws.datazone.model
        .ProvisioningProperties(cloudFormation.map(value => value.asEditable))
    def cloudFormation
        : Optional[zio.aws.datazone.model.CloudFormationProperties.ReadOnly]
    def getCloudFormation: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.CloudFormationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("cloudFormation", cloudFormation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ProvisioningProperties
  ) extends zio.aws.datazone.model.ProvisioningProperties.ReadOnly {
    override val cloudFormation
        : Optional[zio.aws.datazone.model.CloudFormationProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudFormation())
        .map(value =>
          zio.aws.datazone.model.CloudFormationProperties.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ProvisioningProperties
  ): zio.aws.datazone.model.ProvisioningProperties.ReadOnly = new Wrapper(impl)
}
