package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListSubscriptionTargetsResponse(
    items: Iterable[zio.aws.datazone.model.SubscriptionTargetSummary],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse = {
    import ListSubscriptionTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.ListSubscriptionTargetsResponse.ReadOnly =
    zio.aws.datazone.model.ListSubscriptionTargetsResponse.wrap(buildAwsValue())
}
object ListSubscriptionTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListSubscriptionTargetsResponse =
      zio.aws.datazone.model.ListSubscriptionTargetsResponse(
        items.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def items: List[zio.aws.datazone.model.SubscriptionTargetSummary.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.SubscriptionTargetSummary.ReadOnly
    ]] = ZIO.succeed(items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse
  ) extends zio.aws.datazone.model.ListSubscriptionTargetsResponse.ReadOnly {
    override val items
        : List[zio.aws.datazone.model.SubscriptionTargetSummary.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.datazone.model.SubscriptionTargetSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse
  ): zio.aws.datazone.model.ListSubscriptionTargetsResponse.ReadOnly =
    new Wrapper(impl)
}
