package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  ProjectId,
  PaginationToken,
  MaxResults,
  DomainId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListProjectMembershipsRequest(
    domainIdentifier: DomainId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    projectIdentifier: ProjectId,
    sortBy: Optional[zio.aws.datazone.model.SortFieldProject] = Optional.Absent,
    sortOrder: Optional[zio.aws.datazone.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest = {
    import ListProjectMembershipsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .projectIdentifier(ProjectId.unwrap(projectIdentifier): java.lang.String)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.ListProjectMembershipsRequest.ReadOnly =
    zio.aws.datazone.model.ListProjectMembershipsRequest.wrap(buildAwsValue())
}
object ListProjectMembershipsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListProjectMembershipsRequest =
      zio.aws.datazone.model.ListProjectMembershipsRequest(
        domainIdentifier,
        maxResults.map(value => value),
        nextToken.map(value => value),
        projectIdentifier,
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def domainIdentifier: DomainId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def projectIdentifier: ProjectId
    def sortBy: Optional[zio.aws.datazone.model.SortFieldProject]
    def sortOrder: Optional[zio.aws.datazone.model.SortOrder]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProjectIdentifier: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(projectIdentifier)
    def getSortBy: ZIO[Any, AwsError, zio.aws.datazone.model.SortFieldProject] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.datazone.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest
  ) extends zio.aws.datazone.model.ListProjectMembershipsRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val projectIdentifier: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.projectIdentifier())
    override val sortBy: Optional[zio.aws.datazone.model.SortFieldProject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.datazone.model.SortFieldProject.wrap(value))
    override val sortOrder: Optional[zio.aws.datazone.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.datazone.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest
  ): zio.aws.datazone.model.ListProjectMembershipsRequest.ReadOnly =
    new Wrapper(impl)
}
