package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListNotificationsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    notifications: Optional[
      Iterable[zio.aws.datazone.model.NotificationOutput]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListNotificationsResponse = {
    import ListNotificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListNotificationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        notifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notifications)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ListNotificationsResponse.ReadOnly =
    zio.aws.datazone.model.ListNotificationsResponse.wrap(buildAwsValue())
}
object ListNotificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListNotificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListNotificationsResponse =
      zio.aws.datazone.model.ListNotificationsResponse(
        nextToken.map(value => value),
        notifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def notifications
        : Optional[List[zio.aws.datazone.model.NotificationOutput.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNotifications: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.NotificationOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("notifications", notifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListNotificationsResponse
  ) extends zio.aws.datazone.model.ListNotificationsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val notifications
        : Optional[List[zio.aws.datazone.model.NotificationOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.NotificationOutput.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListNotificationsResponse
  ): zio.aws.datazone.model.ListNotificationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
