package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListEnvironmentBlueprintConfigurationsResponse(
    items: Optional[
      Iterable[zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse = {
    import ListEnvironmentBlueprintConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsResponse.ReadOnly =
    zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListEnvironmentBlueprintConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsResponse =
      zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[
      zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem.ReadOnly
    ]]
    def nextToken: Optional[PaginationToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse
  ) extends zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsResponse.ReadOnly {
    override val items: Optional[List[
      zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse
  ): zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
