package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IamUserProfileDetails(
    arn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.IamUserProfileDetails = {
    import IamUserProfileDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.IamUserProfileDetails
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.IamUserProfileDetails.ReadOnly =
    zio.aws.datazone.model.IamUserProfileDetails.wrap(buildAwsValue())
}
object IamUserProfileDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.IamUserProfileDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.IamUserProfileDetails =
      zio.aws.datazone.model.IamUserProfileDetails(arn.map(value => value))
    def arn: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.IamUserProfileDetails
  ) extends zio.aws.datazone.model.IamUserProfileDetails.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.IamUserProfileDetails
  ): zio.aws.datazone.model.IamUserProfileDetails.ReadOnly = new Wrapper(impl)
}
