package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GrantedEntity(
    listing: Optional[zio.aws.datazone.model.ListingRevision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GrantedEntity = {
    import GrantedEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GrantedEntity
      .builder()
      .optionallyWith(listing.map(value => value.buildAwsValue()))(_.listing)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GrantedEntity.ReadOnly =
    zio.aws.datazone.model.GrantedEntity.wrap(buildAwsValue())
}
object GrantedEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GrantedEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GrantedEntity =
      zio.aws.datazone.model
        .GrantedEntity(listing.map(value => value.asEditable))
    def listing: Optional[zio.aws.datazone.model.ListingRevision.ReadOnly]
    def getListing
        : ZIO[Any, AwsError, zio.aws.datazone.model.ListingRevision.ReadOnly] =
      AwsError.unwrapOptionField("listing", listing)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GrantedEntity
  ) extends zio.aws.datazone.model.GrantedEntity.ReadOnly {
    override val listing
        : Optional[zio.aws.datazone.model.ListingRevision.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listing())
        .map(value => zio.aws.datazone.model.ListingRevision.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GrantedEntity
  ): zio.aws.datazone.model.GrantedEntity.ReadOnly = new Wrapper(impl)
}
