package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  UpdatedBy,
  ProjectId,
  CreatedAt,
  DomainId,
  GlossaryDescription,
  GlossaryId,
  GlossaryName,
  CreatedBy,
  UpdatedAt
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetGlossaryResponse(
    createdAt: Optional[CreatedAt] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    description: Optional[GlossaryDescription] = Optional.Absent,
    domainId: DomainId,
    id: GlossaryId,
    name: GlossaryName,
    owningProjectId: ProjectId,
    status: zio.aws.datazone.model.GlossaryStatus,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetGlossaryResponse = {
    import GetGlossaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetGlossaryResponse
      .builder()
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        description.map(value =>
          GlossaryDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .id(GlossaryId.unwrap(id): java.lang.String)
      .name(GlossaryName.unwrap(name): java.lang.String)
      .owningProjectId(ProjectId.unwrap(owningProjectId): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetGlossaryResponse.ReadOnly =
    zio.aws.datazone.model.GetGlossaryResponse.wrap(buildAwsValue())
}
object GetGlossaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetGlossaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetGlossaryResponse =
      zio.aws.datazone.model.GetGlossaryResponse(
        createdAt.map(value => value),
        createdBy.map(value => value),
        description.map(value => value),
        domainId,
        id,
        name,
        owningProjectId,
        status,
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def createdAt: Optional[CreatedAt]
    def createdBy: Optional[CreatedBy]
    def description: Optional[GlossaryDescription]
    def domainId: DomainId
    def id: GlossaryId
    def name: GlossaryName
    def owningProjectId: ProjectId
    def status: zio.aws.datazone.model.GlossaryStatus
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDescription: ZIO[Any, AwsError, GlossaryDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getId: ZIO[Any, Nothing, GlossaryId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, GlossaryName] = ZIO.succeed(name)
    def getOwningProjectId: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(owningProjectId)
    def getStatus: ZIO[Any, Nothing, zio.aws.datazone.model.GlossaryStatus] =
      ZIO.succeed(status)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetGlossaryResponse
  ) extends zio.aws.datazone.model.GetGlossaryResponse.ReadOnly {
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.datazone.model.primitives.CreatedBy(value))
    override val description: Optional[GlossaryDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.datazone.model.primitives.GlossaryDescription(value)
        )
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val id: GlossaryId =
      zio.aws.datazone.model.primitives.GlossaryId(impl.id())
    override val name: GlossaryName =
      zio.aws.datazone.model.primitives.GlossaryName(impl.name())
    override val owningProjectId: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.owningProjectId())
    override val status: zio.aws.datazone.model.GlossaryStatus =
      zio.aws.datazone.model.GlossaryStatus.wrap(impl.status())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.datazone.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.datazone.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetGlossaryResponse
  ): zio.aws.datazone.model.GetGlossaryResponse.ReadOnly = new Wrapper(impl)
}
