package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  Revision,
  FormTypeIdentifier,
  FormName,
  FormInputContentString
}
import scala.jdk.CollectionConverters.*
final case class FormInput(
    content: Optional[FormInputContentString] = Optional.Absent,
    formName: FormName,
    typeIdentifier: Optional[FormTypeIdentifier] = Optional.Absent,
    typeRevision: Optional[Revision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.FormInput = {
    import FormInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.FormInput
      .builder()
      .optionallyWith(
        content.map(value =>
          FormInputContentString.unwrap(value): java.lang.String
        )
      )(_.content)
      .formName(FormName.unwrap(formName): java.lang.String)
      .optionallyWith(
        typeIdentifier.map(value =>
          FormTypeIdentifier.unwrap(value): java.lang.String
        )
      )(_.typeIdentifier)
      .optionallyWith(
        typeRevision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.typeRevision)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.FormInput.ReadOnly =
    zio.aws.datazone.model.FormInput.wrap(buildAwsValue())
}
object FormInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.FormInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.FormInput =
      zio.aws.datazone.model.FormInput(
        content.map(value => value),
        formName,
        typeIdentifier.map(value => value),
        typeRevision.map(value => value)
      )
    def content: Optional[FormInputContentString]
    def formName: FormName
    def typeIdentifier: Optional[FormTypeIdentifier]
    def typeRevision: Optional[Revision]
    def getContent: ZIO[Any, AwsError, FormInputContentString] =
      AwsError.unwrapOptionField("content", content)
    def getFormName: ZIO[Any, Nothing, FormName] = ZIO.succeed(formName)
    def getTypeIdentifier: ZIO[Any, AwsError, FormTypeIdentifier] =
      AwsError.unwrapOptionField("typeIdentifier", typeIdentifier)
    def getTypeRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("typeRevision", typeRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.FormInput
  ) extends zio.aws.datazone.model.FormInput.ReadOnly {
    override val content: Optional[FormInputContentString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.content())
        .map(value =>
          zio.aws.datazone.model.primitives.FormInputContentString(value)
        )
    override val formName: FormName =
      zio.aws.datazone.model.primitives.FormName(impl.formName())
    override val typeIdentifier: Optional[FormTypeIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeIdentifier())
        .map(value =>
          zio.aws.datazone.model.primitives.FormTypeIdentifier(value)
        )
    override val typeRevision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.typeRevision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.FormInput
  ): zio.aws.datazone.model.FormInput.ReadOnly = new Wrapper(impl)
}
