package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{Revision, FormTypeIdentifier}
import scala.jdk.CollectionConverters.*
final case class FormEntryInput(
    required: Optional[Boolean] = Optional.Absent,
    typeIdentifier: FormTypeIdentifier,
    typeRevision: Revision
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.FormEntryInput = {
    import FormEntryInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.FormEntryInput
      .builder()
      .optionallyWith(required.map(value => value: java.lang.Boolean))(
        _.required
      )
      .typeIdentifier(
        FormTypeIdentifier.unwrap(typeIdentifier): java.lang.String
      )
      .typeRevision(Revision.unwrap(typeRevision): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.FormEntryInput.ReadOnly =
    zio.aws.datazone.model.FormEntryInput.wrap(buildAwsValue())
}
object FormEntryInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.FormEntryInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.FormEntryInput =
      zio.aws.datazone.model.FormEntryInput(
        required.map(value => value),
        typeIdentifier,
        typeRevision
      )
    def required: Optional[Boolean]
    def typeIdentifier: FormTypeIdentifier
    def typeRevision: Revision
    def getRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("required", required)
    def getTypeIdentifier: ZIO[Any, Nothing, FormTypeIdentifier] =
      ZIO.succeed(typeIdentifier)
    def getTypeRevision: ZIO[Any, Nothing, Revision] = ZIO.succeed(typeRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.FormEntryInput
  ) extends zio.aws.datazone.model.FormEntryInput.ReadOnly {
    override val required: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.required())
      .map(value => value: Boolean)
    override val typeIdentifier: FormTypeIdentifier =
      zio.aws.datazone.model.primitives
        .FormTypeIdentifier(impl.typeIdentifier())
    override val typeRevision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.typeRevision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.FormEntryInput
  ): zio.aws.datazone.model.FormEntryInput.ReadOnly = new Wrapper(impl)
}
