package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  EnvironmentBlueprintName,
  EnvironmentBlueprintId,
  Description,
  SyntheticTimestamp_date_time
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EnvironmentBlueprintSummary(
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    id: EnvironmentBlueprintId,
    name: EnvironmentBlueprintName,
    provider: String,
    provisioningProperties: zio.aws.datazone.model.ProvisioningProperties,
    updatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintSummary = {
    import EnvironmentBlueprintSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintSummary
      .builder()
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .id(EnvironmentBlueprintId.unwrap(id): java.lang.String)
      .name(EnvironmentBlueprintName.unwrap(name): java.lang.String)
      .provider(provider: java.lang.String)
      .provisioningProperties(provisioningProperties.buildAwsValue())
      .optionallyWith(
        updatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.EnvironmentBlueprintSummary.ReadOnly =
    zio.aws.datazone.model.EnvironmentBlueprintSummary.wrap(buildAwsValue())
}
object EnvironmentBlueprintSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.EnvironmentBlueprintSummary =
      zio.aws.datazone.model.EnvironmentBlueprintSummary(
        createdAt.map(value => value),
        description.map(value => value),
        id,
        name,
        provider,
        provisioningProperties.asEditable,
        updatedAt.map(value => value)
      )
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def description: Optional[Description]
    def id: EnvironmentBlueprintId
    def name: EnvironmentBlueprintName
    def provider: String
    def provisioningProperties
        : zio.aws.datazone.model.ProvisioningProperties.ReadOnly
    def updatedAt: Optional[SyntheticTimestamp_date_time]
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, Nothing, EnvironmentBlueprintId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, EnvironmentBlueprintName] = ZIO.succeed(name)
    def getProvider: ZIO[Any, Nothing, String] = ZIO.succeed(provider)
    def getProvisioningProperties: ZIO[
      Any,
      Nothing,
      zio.aws.datazone.model.ProvisioningProperties.ReadOnly
    ] = ZIO.succeed(provisioningProperties)
    def getUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintSummary
  ) extends zio.aws.datazone.model.EnvironmentBlueprintSummary.ReadOnly {
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val id: EnvironmentBlueprintId =
      zio.aws.datazone.model.primitives.EnvironmentBlueprintId(impl.id())
    override val name: EnvironmentBlueprintName =
      zio.aws.datazone.model.primitives.EnvironmentBlueprintName(impl.name())
    override val provider: String = impl.provider(): String
    override val provisioningProperties
        : zio.aws.datazone.model.ProvisioningProperties.ReadOnly =
      zio.aws.datazone.model.ProvisioningProperties
        .wrap(impl.provisioningProperties())
    override val updatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintSummary
  ): zio.aws.datazone.model.EnvironmentBlueprintSummary.ReadOnly = new Wrapper(
    impl
  )
}
