package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait DomainStatus {
  def unwrap: software.amazon.awssdk.services.datazone.model.DomainStatus
}
object DomainStatus {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.DomainStatus
  ): zio.aws.datazone.model.DomainStatus = value match {
    case software.amazon.awssdk.services.datazone.model.DomainStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.DomainStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.datazone.model.DomainStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.datazone.model.DomainStatus.CREATION_FAILED =>
      val r = CREATION_FAILED
      r
    case software.amazon.awssdk.services.datazone.model.DomainStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.datazone.model.DomainStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.datazone.model.DomainStatus.DELETION_FAILED =>
      val r = DELETION_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.datazone.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DomainStatus =
      software.amazon.awssdk.services.datazone.model.DomainStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.datazone.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DomainStatus =
      software.amazon.awssdk.services.datazone.model.DomainStatus.CREATING
  }
  case object AVAILABLE extends zio.aws.datazone.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DomainStatus =
      software.amazon.awssdk.services.datazone.model.DomainStatus.AVAILABLE
  }
  case object CREATION_FAILED extends zio.aws.datazone.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DomainStatus =
      software.amazon.awssdk.services.datazone.model.DomainStatus.CREATION_FAILED
  }
  case object DELETING extends zio.aws.datazone.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DomainStatus =
      software.amazon.awssdk.services.datazone.model.DomainStatus.DELETING
  }
  case object DELETED extends zio.aws.datazone.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DomainStatus =
      software.amazon.awssdk.services.datazone.model.DomainStatus.DELETED
  }
  case object DELETION_FAILED extends zio.aws.datazone.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DomainStatus =
      software.amazon.awssdk.services.datazone.model.DomainStatus.DELETION_FAILED
  }
}
