package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait DeploymentType {
  def unwrap: software.amazon.awssdk.services.datazone.model.DeploymentType
}
object DeploymentType {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.DeploymentType
  ): zio.aws.datazone.model.DeploymentType = value match {
    case software.amazon.awssdk.services.datazone.model.DeploymentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.DeploymentType.CREATE =>
      val r = CREATE
      r
    case software.amazon.awssdk.services.datazone.model.DeploymentType.UPDATE =>
      val r = UPDATE
      r
    case software.amazon.awssdk.services.datazone.model.DeploymentType.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.DeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DeploymentType =
      software.amazon.awssdk.services.datazone.model.DeploymentType.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE extends zio.aws.datazone.model.DeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DeploymentType =
      software.amazon.awssdk.services.datazone.model.DeploymentType.CREATE
  }
  case object UPDATE extends zio.aws.datazone.model.DeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DeploymentType =
      software.amazon.awssdk.services.datazone.model.DeploymentType.UPDATE
  }
  case object DELETE extends zio.aws.datazone.model.DeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DeploymentType =
      software.amazon.awssdk.services.datazone.model.DeploymentType.DELETE
  }
}
