package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait DeploymentStatus {
  def unwrap: software.amazon.awssdk.services.datazone.model.DeploymentStatus
}
object DeploymentStatus {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.DeploymentStatus
  ): zio.aws.datazone.model.DeploymentStatus = value match {
    case software.amazon.awssdk.services.datazone.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.DeploymentStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.datazone.model.DeploymentStatus.SUCCESSFUL =>
      val r = SUCCESSFUL
      r
    case software.amazon.awssdk.services.datazone.model.DeploymentStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.datazone.model.DeploymentStatus.PENDING_DEPLOYMENT =>
      val r = PENDING_DEPLOYMENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DeploymentStatus =
      software.amazon.awssdk.services.datazone.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.datazone.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DeploymentStatus =
      software.amazon.awssdk.services.datazone.model.DeploymentStatus.IN_PROGRESS
  }
  case object SUCCESSFUL extends zio.aws.datazone.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DeploymentStatus =
      software.amazon.awssdk.services.datazone.model.DeploymentStatus.SUCCESSFUL
  }
  case object FAILED extends zio.aws.datazone.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DeploymentStatus =
      software.amazon.awssdk.services.datazone.model.DeploymentStatus.FAILED
  }
  case object PENDING_DEPLOYMENT
      extends zio.aws.datazone.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DeploymentStatus =
      software.amazon.awssdk.services.datazone.model.DeploymentStatus.PENDING_DEPLOYMENT
  }
}
