package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{ProjectId, DomainId}
import scala.jdk.CollectionConverters.*
final case class DeleteProjectMembershipRequest(
    domainIdentifier: DomainId,
    member: zio.aws.datazone.model.Member,
    projectIdentifier: ProjectId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipRequest = {
    import DeleteProjectMembershipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .member(member.buildAwsValue())
      .projectIdentifier(ProjectId.unwrap(projectIdentifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.DeleteProjectMembershipRequest.ReadOnly =
    zio.aws.datazone.model.DeleteProjectMembershipRequest.wrap(buildAwsValue())
}
object DeleteProjectMembershipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeleteProjectMembershipRequest =
      zio.aws.datazone.model.DeleteProjectMembershipRequest(
        domainIdentifier,
        member.asEditable,
        projectIdentifier
      )
    def domainIdentifier: DomainId
    def member: zio.aws.datazone.model.Member.ReadOnly
    def projectIdentifier: ProjectId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getMember: ZIO[Any, Nothing, zio.aws.datazone.model.Member.ReadOnly] =
      ZIO.succeed(member)
    def getProjectIdentifier: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(projectIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipRequest
  ) extends zio.aws.datazone.model.DeleteProjectMembershipRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val member: zio.aws.datazone.model.Member.ReadOnly =
      zio.aws.datazone.model.Member.wrap(impl.member())
    override val projectIdentifier: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.projectIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipRequest
  ): zio.aws.datazone.model.DeleteProjectMembershipRequest.ReadOnly =
    new Wrapper(impl)
}
