package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{AssetTypeIdentifier, DomainId}
import scala.jdk.CollectionConverters.*
final case class DeleteAssetTypeRequest(
    domainIdentifier: DomainId,
    identifier: AssetTypeIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteAssetTypeRequest = {
    import DeleteAssetTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteAssetTypeRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(AssetTypeIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DeleteAssetTypeRequest.ReadOnly =
    zio.aws.datazone.model.DeleteAssetTypeRequest.wrap(buildAwsValue())
}
object DeleteAssetTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteAssetTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeleteAssetTypeRequest =
      zio.aws.datazone.model
        .DeleteAssetTypeRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: AssetTypeIdentifier
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, AssetTypeIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteAssetTypeRequest
  ) extends zio.aws.datazone.model.DeleteAssetTypeRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: AssetTypeIdentifier =
      zio.aws.datazone.model.primitives.AssetTypeIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteAssetTypeRequest
  ): zio.aws.datazone.model.DeleteAssetTypeRequest.ReadOnly = new Wrapper(impl)
}
