package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{AssetIdentifier, DomainId}
import scala.jdk.CollectionConverters.*
final case class DeleteAssetRequest(
    domainIdentifier: DomainId,
    identifier: AssetIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteAssetRequest = {
    import DeleteAssetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteAssetRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(AssetIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DeleteAssetRequest.ReadOnly =
    zio.aws.datazone.model.DeleteAssetRequest.wrap(buildAwsValue())
}
object DeleteAssetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteAssetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeleteAssetRequest =
      zio.aws.datazone.model.DeleteAssetRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: AssetIdentifier
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, AssetIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteAssetRequest
  ) extends zio.aws.datazone.model.DeleteAssetRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: AssetIdentifier =
      zio.aws.datazone.model.primitives.AssetIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteAssetRequest
  ): zio.aws.datazone.model.DeleteAssetRequest.ReadOnly = new Wrapper(impl)
}
