package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  DataSourceId,
  DomainId,
  DateTime,
  Integer,
  EnvironmentId,
  Name
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DataSourceSummary(
    createdAt: Optional[DateTime] = Optional.Absent,
    dataSourceId: DataSourceId,
    domainId: DomainId,
    enableSetting: Optional[zio.aws.datazone.model.EnableSetting] =
      Optional.Absent,
    environmentId: EnvironmentId,
    lastRunAssetCount: Optional[Integer] = Optional.Absent,
    lastRunAt: Optional[DateTime] = Optional.Absent,
    lastRunErrorMessage: Optional[
      zio.aws.datazone.model.DataSourceErrorMessage
    ] = Optional.Absent,
    lastRunStatus: Optional[zio.aws.datazone.model.DataSourceRunStatus] =
      Optional.Absent,
    name: Name,
    schedule: Optional[zio.aws.datazone.model.ScheduleConfiguration] =
      Optional.Absent,
    status: zio.aws.datazone.model.DataSourceStatus,
    `type`: String,
    updatedAt: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DataSourceSummary = {
    import DataSourceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DataSourceSummary
      .builder()
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .dataSourceId(DataSourceId.unwrap(dataSourceId): java.lang.String)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(enableSetting.map(value => value.unwrap))(_.enableSetting)
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .optionallyWith(lastRunAssetCount.map(value => value: java.lang.Integer))(
        _.lastRunAssetCount
      )
      .optionallyWith(lastRunAt.map(value => DateTime.unwrap(value): Instant))(
        _.lastRunAt
      )
      .optionallyWith(lastRunErrorMessage.map(value => value.buildAwsValue()))(
        _.lastRunErrorMessage
      )
      .optionallyWith(lastRunStatus.map(value => value.unwrap))(_.lastRunStatus)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .status(status.unwrap)
      .`type`(`type`: java.lang.String)
      .optionallyWith(updatedAt.map(value => DateTime.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DataSourceSummary.ReadOnly =
    zio.aws.datazone.model.DataSourceSummary.wrap(buildAwsValue())
}
object DataSourceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DataSourceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DataSourceSummary =
      zio.aws.datazone.model.DataSourceSummary(
        createdAt.map(value => value),
        dataSourceId,
        domainId,
        enableSetting.map(value => value),
        environmentId,
        lastRunAssetCount.map(value => value),
        lastRunAt.map(value => value),
        lastRunErrorMessage.map(value => value.asEditable),
        lastRunStatus.map(value => value),
        name,
        schedule.map(value => value.asEditable),
        status,
        `type`,
        updatedAt.map(value => value)
      )
    def createdAt: Optional[DateTime]
    def dataSourceId: DataSourceId
    def domainId: DomainId
    def enableSetting: Optional[zio.aws.datazone.model.EnableSetting]
    def environmentId: EnvironmentId
    def lastRunAssetCount: Optional[Integer]
    def lastRunAt: Optional[DateTime]
    def lastRunErrorMessage
        : Optional[zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly]
    def lastRunStatus: Optional[zio.aws.datazone.model.DataSourceRunStatus]
    def name: Name
    def schedule
        : Optional[zio.aws.datazone.model.ScheduleConfiguration.ReadOnly]
    def status: zio.aws.datazone.model.DataSourceStatus
    def `type`: String
    def updatedAt: Optional[DateTime]
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDataSourceId: ZIO[Any, Nothing, DataSourceId] =
      ZIO.succeed(dataSourceId)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getEnableSetting
        : ZIO[Any, AwsError, zio.aws.datazone.model.EnableSetting] =
      AwsError.unwrapOptionField("enableSetting", enableSetting)
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getLastRunAssetCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("lastRunAssetCount", lastRunAssetCount)
    def getLastRunAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastRunAt", lastRunAt)
    def getLastRunErrorMessage: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly
    ] = AwsError.unwrapOptionField("lastRunErrorMessage", lastRunErrorMessage)
    def getLastRunStatus
        : ZIO[Any, AwsError, zio.aws.datazone.model.DataSourceRunStatus] =
      AwsError.unwrapOptionField("lastRunStatus", lastRunStatus)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.ScheduleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
    def getStatus: ZIO[Any, Nothing, zio.aws.datazone.model.DataSourceStatus] =
      ZIO.succeed(status)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getUpdatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DataSourceSummary
  ) extends zio.aws.datazone.model.DataSourceSummary.ReadOnly {
    override val createdAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.DateTime(value))
    override val dataSourceId: DataSourceId =
      zio.aws.datazone.model.primitives.DataSourceId(impl.dataSourceId())
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val enableSetting: Optional[zio.aws.datazone.model.EnableSetting] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableSetting())
        .map(value => zio.aws.datazone.model.EnableSetting.wrap(value))
    override val environmentId: EnvironmentId =
      zio.aws.datazone.model.primitives.EnvironmentId(impl.environmentId())
    override val lastRunAssetCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.lastRunAssetCount())
      .map(value => value: Integer)
    override val lastRunAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastRunAt())
      .map(value => zio.aws.datazone.model.primitives.DateTime(value))
    override val lastRunErrorMessage
        : Optional[zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRunErrorMessage())
        .map(value => zio.aws.datazone.model.DataSourceErrorMessage.wrap(value))
    override val lastRunStatus
        : Optional[zio.aws.datazone.model.DataSourceRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRunStatus())
        .map(value => zio.aws.datazone.model.DataSourceRunStatus.wrap(value))
    override val name: Name =
      zio.aws.datazone.model.primitives.Name(impl.name())
    override val schedule
        : Optional[zio.aws.datazone.model.ScheduleConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.datazone.model.ScheduleConfiguration.wrap(value))
    override val status: zio.aws.datazone.model.DataSourceStatus =
      zio.aws.datazone.model.DataSourceStatus.wrap(impl.status())
    override val `type`: String = impl.`type`(): String
    override val updatedAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.datazone.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DataSourceSummary
  ): zio.aws.datazone.model.DataSourceSummary.ReadOnly = new Wrapper(impl)
}
