package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  GlossaryTermId,
  UpdatedBy,
  ProjectId,
  CreatedAt,
  DataProductName,
  DataProductDescription,
  DomainId,
  DataProductId,
  CreatedBy,
  UpdatedAt
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DataProductSummary(
    createdAt: Optional[CreatedAt] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    dataProductItems: Optional[
      Iterable[zio.aws.datazone.model.DataProductItem]
    ] = Optional.Absent,
    description: Optional[DataProductDescription] = Optional.Absent,
    domainId: DomainId,
    glossaryTerms: Optional[Iterable[GlossaryTermId]] = Optional.Absent,
    id: DataProductId,
    name: DataProductName,
    owningProjectId: ProjectId,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DataProductSummary = {
    import DataProductSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DataProductSummary
      .builder()
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        dataProductItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataProductItems)
      .optionallyWith(
        description.map(value =>
          DataProductDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .id(DataProductId.unwrap(id): java.lang.String)
      .name(DataProductName.unwrap(name): java.lang.String)
      .owningProjectId(ProjectId.unwrap(owningProjectId): java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DataProductSummary.ReadOnly =
    zio.aws.datazone.model.DataProductSummary.wrap(buildAwsValue())
}
object DataProductSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DataProductSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DataProductSummary =
      zio.aws.datazone.model.DataProductSummary(
        createdAt.map(value => value),
        createdBy.map(value => value),
        dataProductItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value),
        domainId,
        glossaryTerms.map(value => value),
        id,
        name,
        owningProjectId,
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def createdAt: Optional[CreatedAt]
    def createdBy: Optional[CreatedBy]
    def dataProductItems
        : Optional[List[zio.aws.datazone.model.DataProductItem.ReadOnly]]
    def description: Optional[DataProductDescription]
    def domainId: DomainId
    def glossaryTerms: Optional[List[GlossaryTermId]]
    def id: DataProductId
    def name: DataProductName
    def owningProjectId: ProjectId
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDataProductItems: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.DataProductItem.ReadOnly
    ]] = AwsError.unwrapOptionField("dataProductItems", dataProductItems)
    def getDescription: ZIO[Any, AwsError, DataProductDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getGlossaryTerms: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getId: ZIO[Any, Nothing, DataProductId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, DataProductName] = ZIO.succeed(name)
    def getOwningProjectId: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(owningProjectId)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DataProductSummary
  ) extends zio.aws.datazone.model.DataProductSummary.ReadOnly {
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.datazone.model.primitives.CreatedBy(value))
    override val dataProductItems
        : Optional[List[zio.aws.datazone.model.DataProductItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataProductItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.DataProductItem.wrap(item)
          }.toList
        )
    override val description: Optional[DataProductDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.datazone.model.primitives.DataProductDescription(value)
        )
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val glossaryTerms: Optional[List[GlossaryTermId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.GlossaryTermId(item)
          }.toList
        )
    override val id: DataProductId =
      zio.aws.datazone.model.primitives.DataProductId(impl.id())
    override val name: DataProductName =
      zio.aws.datazone.model.primitives.DataProductName(impl.name())
    override val owningProjectId: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.owningProjectId())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.datazone.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.datazone.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DataProductSummary
  ): zio.aws.datazone.model.DataProductSummary.ReadOnly = new Wrapper(impl)
}
