package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  CustomParameterKeyNameString,
  Description
}
import scala.jdk.CollectionConverters.*
final case class CustomParameter(
    defaultValue: Optional[String] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    fieldType: String,
    isEditable: Optional[Boolean] = Optional.Absent,
    isOptional: Optional[Boolean] = Optional.Absent,
    keyName: CustomParameterKeyNameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CustomParameter = {
    import CustomParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CustomParameter
      .builder()
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .fieldType(fieldType: java.lang.String)
      .optionallyWith(isEditable.map(value => value: java.lang.Boolean))(
        _.isEditable
      )
      .optionallyWith(isOptional.map(value => value: java.lang.Boolean))(
        _.isOptional
      )
      .keyName(CustomParameterKeyNameString.unwrap(keyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CustomParameter.ReadOnly =
    zio.aws.datazone.model.CustomParameter.wrap(buildAwsValue())
}
object CustomParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CustomParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CustomParameter =
      zio.aws.datazone.model.CustomParameter(
        defaultValue.map(value => value),
        description.map(value => value),
        fieldType,
        isEditable.map(value => value),
        isOptional.map(value => value),
        keyName
      )
    def defaultValue: Optional[String]
    def description: Optional[Description]
    def fieldType: String
    def isEditable: Optional[Boolean]
    def isOptional: Optional[Boolean]
    def keyName: CustomParameterKeyNameString
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getFieldType: ZIO[Any, Nothing, String] = ZIO.succeed(fieldType)
    def getIsEditable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEditable", isEditable)
    def getIsOptional: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isOptional", isOptional)
    def getKeyName: ZIO[Any, Nothing, CustomParameterKeyNameString] =
      ZIO.succeed(keyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CustomParameter
  ) extends zio.aws.datazone.model.CustomParameter.ReadOnly {
    override val defaultValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => value: String)
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val fieldType: String = impl.fieldType(): String
    override val isEditable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isEditable())
      .map(value => value: Boolean)
    override val isOptional: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isOptional())
      .map(value => value: Boolean)
    override val keyName: CustomParameterKeyNameString =
      zio.aws.datazone.model.primitives
        .CustomParameterKeyNameString(impl.keyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CustomParameter
  ): zio.aws.datazone.model.CustomParameter.ReadOnly = new Wrapper(impl)
}
