package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{UserIdentifier, DomainId}
import scala.jdk.CollectionConverters.*
final case class CreateUserProfileRequest(
    clientToken: Optional[String] = Optional.Absent,
    domainIdentifier: DomainId,
    userIdentifier: UserIdentifier,
    userType: Optional[zio.aws.datazone.model.UserType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateUserProfileRequest = {
    import CreateUserProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateUserProfileRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .userIdentifier(UserIdentifier.unwrap(userIdentifier): java.lang.String)
      .optionallyWith(userType.map(value => value.unwrap))(_.userType)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateUserProfileRequest.ReadOnly =
    zio.aws.datazone.model.CreateUserProfileRequest.wrap(buildAwsValue())
}
object CreateUserProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateUserProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateUserProfileRequest =
      zio.aws.datazone.model.CreateUserProfileRequest(
        clientToken.map(value => value),
        domainIdentifier,
        userIdentifier,
        userType.map(value => value)
      )
    def clientToken: Optional[String]
    def domainIdentifier: DomainId
    def userIdentifier: UserIdentifier
    def userType: Optional[zio.aws.datazone.model.UserType]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getUserIdentifier: ZIO[Any, Nothing, UserIdentifier] =
      ZIO.succeed(userIdentifier)
    def getUserType: ZIO[Any, AwsError, zio.aws.datazone.model.UserType] =
      AwsError.unwrapOptionField("userType", userType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateUserProfileRequest
  ) extends zio.aws.datazone.model.CreateUserProfileRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val userIdentifier: UserIdentifier =
      zio.aws.datazone.model.primitives.UserIdentifier(impl.userIdentifier())
    override val userType: Optional[zio.aws.datazone.model.UserType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userType())
        .map(value => zio.aws.datazone.model.UserType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateUserProfileRequest
  ): zio.aws.datazone.model.CreateUserProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
