package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{ProjectId, DomainId}
import scala.jdk.CollectionConverters.*
final case class CreateProjectMembershipRequest(
    designation: zio.aws.datazone.model.UserDesignation,
    domainIdentifier: DomainId,
    member: zio.aws.datazone.model.Member,
    projectIdentifier: ProjectId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateProjectMembershipRequest = {
    import CreateProjectMembershipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateProjectMembershipRequest
      .builder()
      .designation(designation.unwrap)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .member(member.buildAwsValue())
      .projectIdentifier(ProjectId.unwrap(projectIdentifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.CreateProjectMembershipRequest.ReadOnly =
    zio.aws.datazone.model.CreateProjectMembershipRequest.wrap(buildAwsValue())
}
object CreateProjectMembershipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateProjectMembershipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateProjectMembershipRequest =
      zio.aws.datazone.model.CreateProjectMembershipRequest(
        designation,
        domainIdentifier,
        member.asEditable,
        projectIdentifier
      )
    def designation: zio.aws.datazone.model.UserDesignation
    def domainIdentifier: DomainId
    def member: zio.aws.datazone.model.Member.ReadOnly
    def projectIdentifier: ProjectId
    def getDesignation
        : ZIO[Any, Nothing, zio.aws.datazone.model.UserDesignation] =
      ZIO.succeed(designation)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getMember: ZIO[Any, Nothing, zio.aws.datazone.model.Member.ReadOnly] =
      ZIO.succeed(member)
    def getProjectIdentifier: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(projectIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateProjectMembershipRequest
  ) extends zio.aws.datazone.model.CreateProjectMembershipRequest.ReadOnly {
    override val designation: zio.aws.datazone.model.UserDesignation =
      zio.aws.datazone.model.UserDesignation.wrap(impl.designation())
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val member: zio.aws.datazone.model.Member.ReadOnly =
      zio.aws.datazone.model.Member.wrap(impl.member())
    override val projectIdentifier: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.projectIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateProjectMembershipRequest
  ): zio.aws.datazone.model.CreateProjectMembershipRequest.ReadOnly =
    new Wrapper(impl)
}
