package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  AssetName,
  GlossaryTermId,
  AssetId,
  ProjectId,
  CreatedAt,
  DomainId,
  Revision,
  ExternalIdentifier,
  Description,
  CreatedBy,
  AssetTypeIdentifier
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateAssetResponse(
    createdAt: Optional[CreatedAt] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    domainId: DomainId,
    externalIdentifier: Optional[ExternalIdentifier] = Optional.Absent,
    firstRevisionCreatedAt: Optional[CreatedAt] = Optional.Absent,
    firstRevisionCreatedBy: Optional[CreatedBy] = Optional.Absent,
    formsOutput: Iterable[zio.aws.datazone.model.FormOutput],
    glossaryTerms: Optional[Iterable[GlossaryTermId]] = Optional.Absent,
    id: AssetId,
    listing: Optional[zio.aws.datazone.model.AssetListingDetails] =
      Optional.Absent,
    name: AssetName,
    owningProjectId: ProjectId,
    predictionConfiguration: Optional[
      zio.aws.datazone.model.PredictionConfiguration
    ] = Optional.Absent,
    readOnlyFormsOutput: Optional[Iterable[zio.aws.datazone.model.FormOutput]] =
      Optional.Absent,
    revision: Revision,
    typeIdentifier: AssetTypeIdentifier,
    typeRevision: Revision
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateAssetResponse = {
    import CreateAssetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateAssetResponse
      .builder()
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(
        externalIdentifier.map(value =>
          ExternalIdentifier.unwrap(value): java.lang.String
        )
      )(_.externalIdentifier)
      .optionallyWith(
        firstRevisionCreatedAt.map(value => CreatedAt.unwrap(value): Instant)
      )(_.firstRevisionCreatedAt)
      .optionallyWith(
        firstRevisionCreatedBy.map(value =>
          CreatedBy.unwrap(value): java.lang.String
        )
      )(_.firstRevisionCreatedBy)
      .formsOutput(formsOutput.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .id(AssetId.unwrap(id): java.lang.String)
      .optionallyWith(listing.map(value => value.buildAwsValue()))(_.listing)
      .name(AssetName.unwrap(name): java.lang.String)
      .owningProjectId(ProjectId.unwrap(owningProjectId): java.lang.String)
      .optionallyWith(
        predictionConfiguration.map(value => value.buildAwsValue())
      )(_.predictionConfiguration)
      .optionallyWith(
        readOnlyFormsOutput.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.readOnlyFormsOutput)
      .revision(Revision.unwrap(revision): java.lang.String)
      .typeIdentifier(
        AssetTypeIdentifier.unwrap(typeIdentifier): java.lang.String
      )
      .typeRevision(Revision.unwrap(typeRevision): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateAssetResponse.ReadOnly =
    zio.aws.datazone.model.CreateAssetResponse.wrap(buildAwsValue())
}
object CreateAssetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateAssetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateAssetResponse =
      zio.aws.datazone.model.CreateAssetResponse(
        createdAt.map(value => value),
        createdBy.map(value => value),
        description.map(value => value),
        domainId,
        externalIdentifier.map(value => value),
        firstRevisionCreatedAt.map(value => value),
        firstRevisionCreatedBy.map(value => value),
        formsOutput.map { item =>
          item.asEditable
        },
        glossaryTerms.map(value => value),
        id,
        listing.map(value => value.asEditable),
        name,
        owningProjectId,
        predictionConfiguration.map(value => value.asEditable),
        readOnlyFormsOutput.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        revision,
        typeIdentifier,
        typeRevision
      )
    def createdAt: Optional[CreatedAt]
    def createdBy: Optional[CreatedBy]
    def description: Optional[Description]
    def domainId: DomainId
    def externalIdentifier: Optional[ExternalIdentifier]
    def firstRevisionCreatedAt: Optional[CreatedAt]
    def firstRevisionCreatedBy: Optional[CreatedBy]
    def formsOutput: List[zio.aws.datazone.model.FormOutput.ReadOnly]
    def glossaryTerms: Optional[List[GlossaryTermId]]
    def id: AssetId
    def listing: Optional[zio.aws.datazone.model.AssetListingDetails.ReadOnly]
    def name: AssetName
    def owningProjectId: ProjectId
    def predictionConfiguration
        : Optional[zio.aws.datazone.model.PredictionConfiguration.ReadOnly]
    def readOnlyFormsOutput
        : Optional[List[zio.aws.datazone.model.FormOutput.ReadOnly]]
    def revision: Revision
    def typeIdentifier: AssetTypeIdentifier
    def typeRevision: Revision
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getExternalIdentifier: ZIO[Any, AwsError, ExternalIdentifier] =
      AwsError.unwrapOptionField("externalIdentifier", externalIdentifier)
    def getFirstRevisionCreatedAt: ZIO[Any, AwsError, CreatedAt] = AwsError
      .unwrapOptionField("firstRevisionCreatedAt", firstRevisionCreatedAt)
    def getFirstRevisionCreatedBy: ZIO[Any, AwsError, CreatedBy] = AwsError
      .unwrapOptionField("firstRevisionCreatedBy", firstRevisionCreatedBy)
    def getFormsOutput
        : ZIO[Any, Nothing, List[zio.aws.datazone.model.FormOutput.ReadOnly]] =
      ZIO.succeed(formsOutput)
    def getGlossaryTerms: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getId: ZIO[Any, Nothing, AssetId] = ZIO.succeed(id)
    def getListing: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.AssetListingDetails.ReadOnly
    ] = AwsError.unwrapOptionField("listing", listing)
    def getName: ZIO[Any, Nothing, AssetName] = ZIO.succeed(name)
    def getOwningProjectId: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(owningProjectId)
    def getPredictionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.PredictionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "predictionConfiguration",
      predictionConfiguration
    )
    def getReadOnlyFormsOutput
        : ZIO[Any, AwsError, List[zio.aws.datazone.model.FormOutput.ReadOnly]] =
      AwsError.unwrapOptionField("readOnlyFormsOutput", readOnlyFormsOutput)
    def getRevision: ZIO[Any, Nothing, Revision] = ZIO.succeed(revision)
    def getTypeIdentifier: ZIO[Any, Nothing, AssetTypeIdentifier] =
      ZIO.succeed(typeIdentifier)
    def getTypeRevision: ZIO[Any, Nothing, Revision] = ZIO.succeed(typeRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateAssetResponse
  ) extends zio.aws.datazone.model.CreateAssetResponse.ReadOnly {
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.datazone.model.primitives.CreatedBy(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val externalIdentifier: Optional[ExternalIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalIdentifier())
        .map(value =>
          zio.aws.datazone.model.primitives.ExternalIdentifier(value)
        )
    override val firstRevisionCreatedAt: Optional[CreatedAt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firstRevisionCreatedAt())
        .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val firstRevisionCreatedBy: Optional[CreatedBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firstRevisionCreatedBy())
        .map(value => zio.aws.datazone.model.primitives.CreatedBy(value))
    override val formsOutput: List[zio.aws.datazone.model.FormOutput.ReadOnly] =
      impl
        .formsOutput()
        .asScala
        .map { item =>
          zio.aws.datazone.model.FormOutput.wrap(item)
        }
        .toList
    override val glossaryTerms: Optional[List[GlossaryTermId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.GlossaryTermId(item)
          }.toList
        )
    override val id: AssetId =
      zio.aws.datazone.model.primitives.AssetId(impl.id())
    override val listing
        : Optional[zio.aws.datazone.model.AssetListingDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listing())
        .map(value => zio.aws.datazone.model.AssetListingDetails.wrap(value))
    override val name: AssetName =
      zio.aws.datazone.model.primitives.AssetName(impl.name())
    override val owningProjectId: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.owningProjectId())
    override val predictionConfiguration
        : Optional[zio.aws.datazone.model.PredictionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictionConfiguration())
        .map(value =>
          zio.aws.datazone.model.PredictionConfiguration.wrap(value)
        )
    override val readOnlyFormsOutput
        : Optional[List[zio.aws.datazone.model.FormOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readOnlyFormsOutput())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.FormOutput.wrap(item)
          }.toList
        )
    override val revision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.revision())
    override val typeIdentifier: AssetTypeIdentifier =
      zio.aws.datazone.model.primitives
        .AssetTypeIdentifier(impl.typeIdentifier())
    override val typeRevision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.typeRevision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateAssetResponse
  ): zio.aws.datazone.model.CreateAssetResponse.ReadOnly = new Wrapper(impl)
}
