package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssetItemAdditionalAttributes(
    formsOutput: Optional[Iterable[zio.aws.datazone.model.FormOutput]] =
      Optional.Absent,
    readOnlyFormsOutput: Optional[Iterable[zio.aws.datazone.model.FormOutput]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AssetItemAdditionalAttributes = {
    import AssetItemAdditionalAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AssetItemAdditionalAttributes
      .builder()
      .optionallyWith(
        formsOutput.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.formsOutput)
      .optionallyWith(
        readOnlyFormsOutput.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.readOnlyFormsOutput)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.AssetItemAdditionalAttributes.ReadOnly =
    zio.aws.datazone.model.AssetItemAdditionalAttributes.wrap(buildAwsValue())
}
object AssetItemAdditionalAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AssetItemAdditionalAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.AssetItemAdditionalAttributes =
      zio.aws.datazone.model.AssetItemAdditionalAttributes(
        formsOutput.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        readOnlyFormsOutput.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def formsOutput: Optional[List[zio.aws.datazone.model.FormOutput.ReadOnly]]
    def readOnlyFormsOutput
        : Optional[List[zio.aws.datazone.model.FormOutput.ReadOnly]]
    def getFormsOutput
        : ZIO[Any, AwsError, List[zio.aws.datazone.model.FormOutput.ReadOnly]] =
      AwsError.unwrapOptionField("formsOutput", formsOutput)
    def getReadOnlyFormsOutput
        : ZIO[Any, AwsError, List[zio.aws.datazone.model.FormOutput.ReadOnly]] =
      AwsError.unwrapOptionField("readOnlyFormsOutput", readOnlyFormsOutput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AssetItemAdditionalAttributes
  ) extends zio.aws.datazone.model.AssetItemAdditionalAttributes.ReadOnly {
    override val formsOutput
        : Optional[List[zio.aws.datazone.model.FormOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formsOutput())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.FormOutput.wrap(item)
          }.toList
        )
    override val readOnlyFormsOutput
        : Optional[List[zio.aws.datazone.model.FormOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readOnlyFormsOutput())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.FormOutput.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AssetItemAdditionalAttributes
  ): zio.aws.datazone.model.AssetItemAdditionalAttributes.ReadOnly =
    new Wrapper(impl)
}
