package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{Revision, DomainId, AssetId}
import scala.jdk.CollectionConverters.*
final case class AcceptPredictionsResponse(
    assetId: AssetId,
    domainId: DomainId,
    revision: Revision
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AcceptPredictionsResponse = {
    import AcceptPredictionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AcceptPredictionsResponse
      .builder()
      .assetId(AssetId.unwrap(assetId): java.lang.String)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .revision(Revision.unwrap(revision): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.AcceptPredictionsResponse.ReadOnly =
    zio.aws.datazone.model.AcceptPredictionsResponse.wrap(buildAwsValue())
}
object AcceptPredictionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AcceptPredictionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.AcceptPredictionsResponse =
      zio.aws.datazone.model
        .AcceptPredictionsResponse(assetId, domainId, revision)
    def assetId: AssetId
    def domainId: DomainId
    def revision: Revision
    def getAssetId: ZIO[Any, Nothing, AssetId] = ZIO.succeed(assetId)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getRevision: ZIO[Any, Nothing, Revision] = ZIO.succeed(revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AcceptPredictionsResponse
  ) extends zio.aws.datazone.model.AcceptPredictionsResponse.ReadOnly {
    override val assetId: AssetId =
      zio.aws.datazone.model.primitives.AssetId(impl.assetId())
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val revision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.revision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AcceptPredictionsResponse
  ): zio.aws.datazone.model.AcceptPredictionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
