package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait UserType {
  def unwrap: software.amazon.awssdk.services.datazone.model.UserType
}
object UserType {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.UserType
  ): zio.aws.datazone.model.UserType = value match {
    case software.amazon.awssdk.services.datazone.model.UserType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.UserType.IAM_USER =>
      val r = IAM_USER
      r
    case software.amazon.awssdk.services.datazone.model.UserType.IAM_ROLE =>
      val r = IAM_ROLE
      r
    case software.amazon.awssdk.services.datazone.model.UserType.SSO_USER =>
      val r = SSO_USER
      r
  }
  case object unknownToSdkVersion extends zio.aws.datazone.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserType =
      software.amazon.awssdk.services.datazone.model.UserType.UNKNOWN_TO_SDK_VERSION
  }
  case object IAM_USER extends zio.aws.datazone.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserType =
      software.amazon.awssdk.services.datazone.model.UserType.IAM_USER
  }
  case object IAM_ROLE extends zio.aws.datazone.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserType =
      software.amazon.awssdk.services.datazone.model.UserType.IAM_ROLE
  }
  case object SSO_USER extends zio.aws.datazone.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserType =
      software.amazon.awssdk.services.datazone.model.UserType.SSO_USER
  }
}
