package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UserProfileDetails(
    iam: Optional[zio.aws.datazone.model.IamUserProfileDetails] =
      Optional.Absent,
    sso: Optional[zio.aws.datazone.model.SsoUserProfileDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UserProfileDetails = {
    import UserProfileDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UserProfileDetails
      .builder()
      .optionallyWith(iam.map(value => value.buildAwsValue()))(_.iam)
      .optionallyWith(sso.map(value => value.buildAwsValue()))(_.sso)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UserProfileDetails.ReadOnly =
    zio.aws.datazone.model.UserProfileDetails.wrap(buildAwsValue())
}
object UserProfileDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UserProfileDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UserProfileDetails =
      zio.aws.datazone.model.UserProfileDetails(
        iam.map(value => value.asEditable),
        sso.map(value => value.asEditable)
      )
    def iam: Optional[zio.aws.datazone.model.IamUserProfileDetails.ReadOnly]
    def sso: Optional[zio.aws.datazone.model.SsoUserProfileDetails.ReadOnly]
    def getIam: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.IamUserProfileDetails.ReadOnly
    ] = AwsError.unwrapOptionField("iam", iam)
    def getSso: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.SsoUserProfileDetails.ReadOnly
    ] = AwsError.unwrapOptionField("sso", sso)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UserProfileDetails
  ) extends zio.aws.datazone.model.UserProfileDetails.ReadOnly {
    override val iam
        : Optional[zio.aws.datazone.model.IamUserProfileDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iam())
        .map(value => zio.aws.datazone.model.IamUserProfileDetails.wrap(value))
    override val sso
        : Optional[zio.aws.datazone.model.SsoUserProfileDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sso())
        .map(value => zio.aws.datazone.model.SsoUserProfileDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UserProfileDetails
  ): zio.aws.datazone.model.UserProfileDetails.ReadOnly = new Wrapper(impl)
}
