package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{UserIdentifier, DomainId}
import scala.jdk.CollectionConverters.*
final case class UpdateUserProfileRequest(
    domainIdentifier: DomainId,
    status: zio.aws.datazone.model.UserProfileStatus,
    `type`: Optional[zio.aws.datazone.model.UserProfileType] = Optional.Absent,
    userIdentifier: UserIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateUserProfileRequest = {
    import UpdateUserProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateUserProfileRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .userIdentifier(UserIdentifier.unwrap(userIdentifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UpdateUserProfileRequest.ReadOnly =
    zio.aws.datazone.model.UpdateUserProfileRequest.wrap(buildAwsValue())
}
object UpdateUserProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateUserProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateUserProfileRequest =
      zio.aws.datazone.model.UpdateUserProfileRequest(
        domainIdentifier,
        status,
        `type`.map(value => value),
        userIdentifier
      )
    def domainIdentifier: DomainId
    def status: zio.aws.datazone.model.UserProfileStatus
    def `type`: Optional[zio.aws.datazone.model.UserProfileType]
    def userIdentifier: UserIdentifier
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getStatus: ZIO[Any, Nothing, zio.aws.datazone.model.UserProfileStatus] =
      ZIO.succeed(status)
    def getType: ZIO[Any, AwsError, zio.aws.datazone.model.UserProfileType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUserIdentifier: ZIO[Any, Nothing, UserIdentifier] =
      ZIO.succeed(userIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateUserProfileRequest
  ) extends zio.aws.datazone.model.UpdateUserProfileRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val status: zio.aws.datazone.model.UserProfileStatus =
      zio.aws.datazone.model.UserProfileStatus.wrap(impl.status())
    override val `type`: Optional[zio.aws.datazone.model.UserProfileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.datazone.model.UserProfileType.wrap(value))
    override val userIdentifier: UserIdentifier =
      zio.aws.datazone.model.primitives.UserIdentifier(impl.userIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateUserProfileRequest
  ): zio.aws.datazone.model.UpdateUserProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
