package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  GlossaryTermId,
  ProjectName,
  ProjectId,
  DomainId,
  Description
}
import scala.jdk.CollectionConverters.*
final case class UpdateProjectRequest(
    description: Optional[Description] = Optional.Absent,
    domainIdentifier: DomainId,
    glossaryTerms: Optional[Iterable[GlossaryTermId]] = Optional.Absent,
    identifier: ProjectId,
    name: Optional[ProjectName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateProjectRequest = {
    import UpdateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateProjectRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .identifier(ProjectId.unwrap(identifier): java.lang.String)
      .optionallyWith(
        name.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UpdateProjectRequest.ReadOnly =
    zio.aws.datazone.model.UpdateProjectRequest.wrap(buildAwsValue())
}
object UpdateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateProjectRequest =
      zio.aws.datazone.model.UpdateProjectRequest(
        description.map(value => value),
        domainIdentifier,
        glossaryTerms.map(value => value),
        identifier,
        name.map(value => value)
      )
    def description: Optional[Description]
    def domainIdentifier: DomainId
    def glossaryTerms: Optional[List[GlossaryTermId]]
    def identifier: ProjectId
    def name: Optional[ProjectName]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getGlossaryTerms: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getIdentifier: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(identifier)
    def getName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateProjectRequest
  ) extends zio.aws.datazone.model.UpdateProjectRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val glossaryTerms: Optional[List[GlossaryTermId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.GlossaryTermId(item)
          }.toList
        )
    override val identifier: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.identifier())
    override val name: Optional[ProjectName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datazone.model.primitives.ProjectName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateProjectRequest
  ): zio.aws.datazone.model.UpdateProjectRequest.ReadOnly = new Wrapper(impl)
}
