package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  GroupProfileId,
  GroupProfileName,
  DomainId
}
import scala.jdk.CollectionConverters.*
final case class UpdateGroupProfileResponse(
    domainId: Optional[DomainId] = Optional.Absent,
    groupName: Optional[GroupProfileName] = Optional.Absent,
    id: Optional[GroupProfileId] = Optional.Absent,
    status: Optional[zio.aws.datazone.model.GroupProfileStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateGroupProfileResponse = {
    import UpdateGroupProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateGroupProfileResponse
      .builder()
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        groupName.map(value => GroupProfileName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        id.map(value => GroupProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UpdateGroupProfileResponse.ReadOnly =
    zio.aws.datazone.model.UpdateGroupProfileResponse.wrap(buildAwsValue())
}
object UpdateGroupProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateGroupProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateGroupProfileResponse =
      zio.aws.datazone.model.UpdateGroupProfileResponse(
        domainId.map(value => value),
        groupName.map(value => value),
        id.map(value => value),
        status.map(value => value)
      )
    def domainId: Optional[DomainId]
    def groupName: Optional[GroupProfileName]
    def id: Optional[GroupProfileId]
    def status: Optional[zio.aws.datazone.model.GroupProfileStatus]
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getGroupName: ZIO[Any, AwsError, GroupProfileName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getId: ZIO[Any, AwsError, GroupProfileId] =
      AwsError.unwrapOptionField("id", id)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datazone.model.GroupProfileStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateGroupProfileResponse
  ) extends zio.aws.datazone.model.UpdateGroupProfileResponse.ReadOnly {
    override val domainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainId())
      .map(value => zio.aws.datazone.model.primitives.DomainId(value))
    override val groupName: Optional[GroupProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.datazone.model.primitives.GroupProfileName(value))
    override val id: Optional[GroupProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.datazone.model.primitives.GroupProfileId(value))
    override val status: Optional[zio.aws.datazone.model.GroupProfileStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.GroupProfileStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateGroupProfileResponse
  ): zio.aws.datazone.model.UpdateGroupProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
