package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{GroupIdentifier, DomainId}
import scala.jdk.CollectionConverters.*
final case class UpdateGroupProfileRequest(
    domainIdentifier: DomainId,
    groupIdentifier: GroupIdentifier,
    status: zio.aws.datazone.model.GroupProfileStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateGroupProfileRequest = {
    import UpdateGroupProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateGroupProfileRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .groupIdentifier(
        GroupIdentifier.unwrap(groupIdentifier): java.lang.String
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UpdateGroupProfileRequest.ReadOnly =
    zio.aws.datazone.model.UpdateGroupProfileRequest.wrap(buildAwsValue())
}
object UpdateGroupProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateGroupProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateGroupProfileRequest =
      zio.aws.datazone.model
        .UpdateGroupProfileRequest(domainIdentifier, groupIdentifier, status)
    def domainIdentifier: DomainId
    def groupIdentifier: GroupIdentifier
    def status: zio.aws.datazone.model.GroupProfileStatus
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getGroupIdentifier: ZIO[Any, Nothing, GroupIdentifier] =
      ZIO.succeed(groupIdentifier)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.datazone.model.GroupProfileStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateGroupProfileRequest
  ) extends zio.aws.datazone.model.UpdateGroupProfileRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val groupIdentifier: GroupIdentifier =
      zio.aws.datazone.model.primitives.GroupIdentifier(impl.groupIdentifier())
    override val status: zio.aws.datazone.model.GroupProfileStatus =
      zio.aws.datazone.model.GroupProfileStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateGroupProfileRequest
  ): zio.aws.datazone.model.UpdateGroupProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
