package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  ProjectId,
  DomainId,
  GlossaryDescription,
  GlossaryId,
  GlossaryName
}
import scala.jdk.CollectionConverters.*
final case class UpdateGlossaryResponse(
    description: Optional[GlossaryDescription] = Optional.Absent,
    domainId: DomainId,
    id: GlossaryId,
    name: GlossaryName,
    owningProjectId: ProjectId,
    status: Optional[zio.aws.datazone.model.GlossaryStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateGlossaryResponse = {
    import UpdateGlossaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateGlossaryResponse
      .builder()
      .optionallyWith(
        description.map(value =>
          GlossaryDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .id(GlossaryId.unwrap(id): java.lang.String)
      .name(GlossaryName.unwrap(name): java.lang.String)
      .owningProjectId(ProjectId.unwrap(owningProjectId): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UpdateGlossaryResponse.ReadOnly =
    zio.aws.datazone.model.UpdateGlossaryResponse.wrap(buildAwsValue())
}
object UpdateGlossaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateGlossaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateGlossaryResponse =
      zio.aws.datazone.model.UpdateGlossaryResponse(
        description.map(value => value),
        domainId,
        id,
        name,
        owningProjectId,
        status.map(value => value)
      )
    def description: Optional[GlossaryDescription]
    def domainId: DomainId
    def id: GlossaryId
    def name: GlossaryName
    def owningProjectId: ProjectId
    def status: Optional[zio.aws.datazone.model.GlossaryStatus]
    def getDescription: ZIO[Any, AwsError, GlossaryDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getId: ZIO[Any, Nothing, GlossaryId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, GlossaryName] = ZIO.succeed(name)
    def getOwningProjectId: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(owningProjectId)
    def getStatus: ZIO[Any, AwsError, zio.aws.datazone.model.GlossaryStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateGlossaryResponse
  ) extends zio.aws.datazone.model.UpdateGlossaryResponse.ReadOnly {
    override val description: Optional[GlossaryDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.datazone.model.primitives.GlossaryDescription(value)
        )
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val id: GlossaryId =
      zio.aws.datazone.model.primitives.GlossaryId(impl.id())
    override val name: GlossaryName =
      zio.aws.datazone.model.primitives.GlossaryName(impl.name())
    override val owningProjectId: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.owningProjectId())
    override val status: Optional[zio.aws.datazone.model.GlossaryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.GlossaryStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateGlossaryResponse
  ): zio.aws.datazone.model.UpdateGlossaryResponse.ReadOnly = new Wrapper(impl)
}
