package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  DomainId,
  GlossaryDescription,
  GlossaryId,
  GlossaryName,
  ClientToken
}
import scala.jdk.CollectionConverters.*
final case class UpdateGlossaryRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[GlossaryDescription] = Optional.Absent,
    domainIdentifier: DomainId,
    identifier: GlossaryId,
    name: Optional[GlossaryName] = Optional.Absent,
    status: Optional[zio.aws.datazone.model.GlossaryStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateGlossaryRequest = {
    import UpdateGlossaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateGlossaryRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          GlossaryDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(GlossaryId.unwrap(identifier): java.lang.String)
      .optionallyWith(
        name.map(value => GlossaryName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UpdateGlossaryRequest.ReadOnly =
    zio.aws.datazone.model.UpdateGlossaryRequest.wrap(buildAwsValue())
}
object UpdateGlossaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateGlossaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateGlossaryRequest =
      zio.aws.datazone.model.UpdateGlossaryRequest(
        clientToken.map(value => value),
        description.map(value => value),
        domainIdentifier,
        identifier,
        name.map(value => value),
        status.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[GlossaryDescription]
    def domainIdentifier: DomainId
    def identifier: GlossaryId
    def name: Optional[GlossaryName]
    def status: Optional[zio.aws.datazone.model.GlossaryStatus]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, GlossaryDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, GlossaryId] = ZIO.succeed(identifier)
    def getName: ZIO[Any, AwsError, GlossaryName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.datazone.model.GlossaryStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateGlossaryRequest
  ) extends zio.aws.datazone.model.UpdateGlossaryRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.datazone.model.primitives.ClientToken(value))
    override val description: Optional[GlossaryDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.datazone.model.primitives.GlossaryDescription(value)
        )
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: GlossaryId =
      zio.aws.datazone.model.primitives.GlossaryId(impl.identifier())
    override val name: Optional[GlossaryName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datazone.model.primitives.GlossaryName(value))
    override val status: Optional[zio.aws.datazone.model.GlossaryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.GlossaryStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateGlossaryRequest
  ): zio.aws.datazone.model.UpdateGlossaryRequest.ReadOnly = new Wrapper(impl)
}
