package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Topic(
    resource: zio.aws.datazone.model.NotificationResource,
    role: zio.aws.datazone.model.NotificationRole,
    subject: String
) {
  def buildAwsValue(): software.amazon.awssdk.services.datazone.model.Topic = {
    import Topic.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.Topic
      .builder()
      .resource(resource.buildAwsValue())
      .role(role.unwrap)
      .subject(subject: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.Topic.ReadOnly =
    zio.aws.datazone.model.Topic.wrap(buildAwsValue())
}
object Topic {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.datazone.model.Topic] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.Topic =
      zio.aws.datazone.model.Topic(resource.asEditable, role, subject)
    def resource: zio.aws.datazone.model.NotificationResource.ReadOnly
    def role: zio.aws.datazone.model.NotificationRole
    def subject: String
    def getResource: ZIO[
      Any,
      Nothing,
      zio.aws.datazone.model.NotificationResource.ReadOnly
    ] = ZIO.succeed(resource)
    def getRole: ZIO[Any, Nothing, zio.aws.datazone.model.NotificationRole] =
      ZIO.succeed(role)
    def getSubject: ZIO[Any, Nothing, String] = ZIO.succeed(subject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.Topic
  ) extends zio.aws.datazone.model.Topic.ReadOnly {
    override val resource
        : zio.aws.datazone.model.NotificationResource.ReadOnly =
      zio.aws.datazone.model.NotificationResource.wrap(impl.resource())
    override val role: zio.aws.datazone.model.NotificationRole =
      zio.aws.datazone.model.NotificationRole.wrap(impl.role())
    override val subject: String = impl.subject(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.Topic
  ): zio.aws.datazone.model.Topic.ReadOnly = new Wrapper(impl)
}
