package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.FormName
import scala.jdk.CollectionConverters.*
final case class SubscriptionTargetForm(content: String, formName: FormName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm = {
    import SubscriptionTargetForm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm
      .builder()
      .content(content: java.lang.String)
      .formName(FormName.unwrap(formName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SubscriptionTargetForm.ReadOnly =
    zio.aws.datazone.model.SubscriptionTargetForm.wrap(buildAwsValue())
}
object SubscriptionTargetForm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SubscriptionTargetForm =
      zio.aws.datazone.model.SubscriptionTargetForm(content, formName)
    def content: String
    def formName: FormName
    def getContent: ZIO[Any, Nothing, String] = ZIO.succeed(content)
    def getFormName: ZIO[Any, Nothing, FormName] = ZIO.succeed(formName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm
  ) extends zio.aws.datazone.model.SubscriptionTargetForm.ReadOnly {
    override val content: String = impl.content(): String
    override val formName: FormName =
      zio.aws.datazone.model.primitives.FormName(impl.formName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm
  ): zio.aws.datazone.model.SubscriptionTargetForm.ReadOnly = new Wrapper(impl)
}
